unit ResourceExplorer.ResourceExplorer;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel, System.Drawing.Imaging,
  System.Windows.Forms, System.Data, System.Resources, System.IO;

type
  TDynImageFormat = array of ImageFormat;
  
  Form1 = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
                resourcesTreeView: System.Windows.Forms.TreeView;
                StatusBar1: System.Windows.Forms.StatusBar;
                MainMenu1: System.Windows.Forms.MainMenu;
                OpenFileDialog1: System.Windows.Forms.OpenFileDialog;
                MenuItem1: System.Windows.Forms.MenuItem;
                fileOpenMenuItem: System.Windows.Forms.MenuItem;
                MenuItem3: System.Windows.Forms.MenuItem;
                fileExitMenuItem: System.Windows.Forms.MenuItem;
                MenuItem5: System.Windows.Forms.MenuItem;
                helpAboutMenuItem: System.Windows.Forms.MenuItem;
                ToolTip1: System.Windows.Forms.ToolTip;
                Panel1: System.Windows.Forms.Panel;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
                procedure fileOpenMenuItem_Click(sender: System.Object; e: System.EventArgs);
                procedure resourcesTreeView_AfterSelect(sender: System.Object;
                                e: System.Windows.Forms.TreeViewEventArgs);
                procedure resourcesTreeView_DoubleClick(sender: System.Object;
                                e: System.EventArgs);
                procedure fileExitMenuItem_Click(sender: System.Object; e: System.EventArgs);
                procedure resourcesTreeView_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
                procedure helpAboutMenuItem_Click(sender: System.Object; e: System.EventArgs);
                procedure resourcesTreeView_MouseMove(sender: System.Object; 
                                e: System.Windows.Forms.MouseEventArgs);
  private
    procedure LoadResourcesFromAssemblyFile(parent: TreeNode;
      fileName: string);
    procedure LoadResourcesFromFile(fileName: string);
    procedure LoadResourcesFromResourcesFile(parent: TreeNode;
      fileName: string);
    procedure LoadResourcesFromResourcesStream(parent: TreeNode;
      stream: Stream);
    procedure LoadResourcesFromResxFile(parent: TreeNode;
      fileName: string);
    procedure ShowSelectedNode;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    Resources: Hashtable;
    ImageFormats: TDynImageFormat;
    procedure Dispose(Disposing: Boolean); override;
    procedure ClearResources;
  public
    constructor Create;
  end;

implementation

uses System.Reflection;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure Form1.InitializeComponent;
type
        TSystem_Windows_Forms_MenuItemArray = array of System.Windows.Forms.MenuItem;
begin
        Self.components := System.ComponentModel.Container.Create;
        Self.OpenFileDialog1 := System.Windows.Forms.OpenFileDialog.Create;
        Self.MainMenu1 := System.Windows.Forms.MainMenu.Create;
        Self.MenuItem1 := System.Windows.Forms.MenuItem.Create;
        Self.fileOpenMenuItem := System.Windows.Forms.MenuItem.Create;
        Self.MenuItem3 := System.Windows.Forms.MenuItem.Create;
        Self.fileExitMenuItem := System.Windows.Forms.MenuItem.Create;
        Self.MenuItem5 := System.Windows.Forms.MenuItem.Create;
        Self.helpAboutMenuItem := System.Windows.Forms.MenuItem.Create;
        Self.ToolTip1 := System.Windows.Forms.ToolTip.Create(Self.components);
        Self.StatusBar1 := System.Windows.Forms.StatusBar.Create;
        Self.Panel1 := System.Windows.Forms.Panel.Create;
        Self.resourcesTreeView := System.Windows.Forms.TreeView.Create;
        Self.Panel1.SuspendLayout;
        Self.SuspendLayout;
        // 
        // MainMenu1
        // 
        Self.MainMenu1.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.MenuItem1, Self.MenuItem5));
        // 
        // MenuItem1
        // 
        Self.MenuItem1.Index := 0;
        Self.MenuItem1.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.fileOpenMenuItem, Self.MenuItem3, Self.fileExitMenuItem));
        Self.MenuItem1.Text := 'File';
        // 
        // fileOpenMenuItem
        // 
        Self.fileOpenMenuItem.Index := 0;
        Self.fileOpenMenuItem.Text := 'Open...';
        Include(Self.fileOpenMenuItem.Click, Self.fileOpenMenuItem_Click);
        // 
        // MenuItem3
        // 
        Self.MenuItem3.Index := 1;
        Self.MenuItem3.Text := '-';
        // 
        // fileExitMenuItem
        // 
        Self.fileExitMenuItem.Index := 2;
        Self.fileExitMenuItem.Text := 'Exit';
        Include(Self.fileExitMenuItem.Click, Self.fileExitMenuItem_Click);
        // 
        // MenuItem5
        // 
        Self.MenuItem5.Index := 1;
        Self.MenuItem5.MenuItems.AddRange(TSystem_Windows_Forms_MenuItemArray.Create(Self.helpAboutMenuItem));
        Self.MenuItem5.Text := 'Help';
        // 
        // helpAboutMenuItem
        // 
        Self.helpAboutMenuItem.Index := 0;
        Self.helpAboutMenuItem.Text := 'About';
        Include(Self.helpAboutMenuItem.Click, Self.helpAboutMenuItem_Click);
        // 
        // StatusBar1
        // 
        Self.StatusBar1.Location := System.Drawing.Point.Create(0, 251);
        Self.StatusBar1.Name := 'StatusBar1';
        Self.StatusBar1.Size := System.Drawing.Size.Create(440, 22);
        Self.StatusBar1.TabIndex := 1;
        // 
        // Panel1
        // 
        Self.Panel1.Controls.Add(Self.resourcesTreeView);
        Self.Panel1.Dock := System.Windows.Forms.DockStyle.Fill;
        Self.Panel1.Location := System.Drawing.Point.Create(0, 0);
        Self.Panel1.Name := 'Panel1';
        Self.Panel1.Size := System.Drawing.Size.Create(440, 251);
        Self.Panel1.TabIndex := 2;
        // 
        // resourcesTreeView
        // 
        Self.resourcesTreeView.Dock := System.Windows.Forms.DockStyle.Fill;
        Self.resourcesTreeView.ImageIndex := -1;
        Self.resourcesTreeView.Location := System.Drawing.Point.Create(0, 0);
        Self.resourcesTreeView.Name := 'resourcesTreeView';
        Self.resourcesTreeView.SelectedImageIndex := -1;
        Self.resourcesTreeView.Size := System.Drawing.Size.Create(440, 251);
        Self.resourcesTreeView.TabIndex := 1;
        Include(Self.resourcesTreeView.KeyDown, Self.resourcesTreeView_KeyDown);
        Include(Self.resourcesTreeView.DoubleClick, Self.resourcesTreeView_DoubleClick);
        Include(Self.resourcesTreeView.AfterSelect, Self.resourcesTreeView_AfterSelect);
        Include(Self.resourcesTreeView.MouseMove, Self.resourcesTreeView_MouseMove);
        // 
        // Form1
        // 
        Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
        Self.ClientSize := System.Drawing.Size.Create(440, 273);
        Self.Controls.Add(Self.Panel1);
        Self.Controls.Add(Self.StatusBar1);
        Self.Menu := Self.MainMenu1;
        Self.Name := 'Form1';
        Self.Text := 'Resource Explorer';
        Self.Panel1.ResumeLayout(False);
        Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure Form1.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor Form1.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  ImageFormats := TDynImageFormat.Create(ImageFormat.Bmp, ImageFormat.Emf, ImageFormat.Exif, ImageFormat.Gif,
  		   ImageFormat.Icon, ImageFormat.jpeg, ImageFormat.Png, ImageFormat.Tiff,
  		   ImageFormat.Wmf);
  Resources := Hashtable.Create;
  LoadResourcesFromFile(ParamStr(0));
end;

procedure Form1.resourcesTreeView_MouseMove(sender: System.Object; e: System.Windows.Forms.MouseEventArgs);
var
 Node: TreeNode;
begin
  Node := resourcesTreeView.GetNodeAt(e.X, e.Y);
  if (node <> nil) and (node.Tag <> nil) then
    ToolTip1.SetToolTip(resourcesTreeView, 'Type: '+node.GetType.ToString+' Value: '+node.Tag.ToString);
end;

procedure Form1.LoadResourcesFromFile(fileName: string);
var
  root: TreeNode;
  ext: string;
begin
  try
    resourcesTreeView.Nodes.Clear;
    root := resourcesTreeView.Nodes.Add(Path.GetFileName(fileName));

    ext := System.IO.Path.GetExtension(fileName).ToLower;
    try
      Cursor := Cursors.WaitCursor;
      if (ext = '.exe') or (ext = '.dll') then
        LoadResourcesFromAssemblyFile(root, fileName) else
      if ext = '.resx' then
        LoadResourcesFromResxFile(root, fileName) else
      if ext = '.resources' then
        LoadResourcesFromResourcesFile(root, fileName) else
        MessageBox.Show('Unknown file format');
    finally
      Cursor := Cursors.Default;
    end;
    root.Expand;
  except
    on E: Exception do
      MessageBox.Show(E.Message, 'An exception has occurred.');
  end;
end;

procedure Form1.LoadResourcesFromAssemblyFile(parent: TreeNode; fileName: string);
var
  assem: Assembly;
  I: Integer;
  ResourcesName: array of string;
  Node: TreeNode;
  ResourceName: string;
  Stream: System.IO.Stream;
begin
  assem := Assembly.LoadFrom(fileName);
  if assem <> nil then
   begin
     ResourcesName := assem.GetManifestResourceNames;
     for I := Low(ResourcesName) to High(ResourcesName) do
       begin
         resourceName := ResourcesName[I];
         node := parent.Nodes.Add(resourceName);
         if resourceName.ToLower.EndsWith('.resources') then
         begin
           stream := assem.GetManifestResourceStream(resourceName);
           LoadResourcesFromResourcesStream(node, stream);
         end;
       end;
   end;
end;

procedure Form1.LoadResourcesFromResxFile(parent: TreeNode; fileName: string);
var
 Reader: ResXResourceReader;
 Node: TreeNode;
 id: IDictionaryEnumerator;
 Entry: DictionaryEntry;
 ResourceName: string;
begin
  reader := ResXResourceReader.Create(fileName);
  id := reader.GetEnumerator;
  while id.MoveNext do
   begin
    Entry := DictionaryEntry(id.Current);
    ResourceName := entry.Key.ToString;
    node := parent.Nodes.Add(System.string.Format('{0} ({1})', ResourceName, entry.Value.GetType));
    node.Tag := entry.Value;
   end;
end;

procedure Form1.LoadResourcesFromResourcesFile(parent: TreeNode; fileName: string);
var
 Stream: FileStream;
begin
 Stream := FileStream.Create(fileName, FileMode.Open, FileAccess.Read);
 LoadResourcesFromResourcesStream(parent, Stream);
end;

procedure Form1.LoadResourcesFromResourcesStream(parent: TreeNode; stream: Stream);
var
 Reader: ResourceReader;
 id: IDictionaryEnumerator;
 Entry: DictionaryEntry;
 ResourceName: string;
 temp: string;
 node: TreeNode;
begin
  Reader := ResourceReader.Create(Stream);
  id := reader.GetEnumerator;
  while id.MoveNext do
   begin
    Entry := DictionaryEntry(id.Current);
    if entry.Value <> nil then
     begin
      temp := entry.Value.GetType.ToString;
      ResourceName := entry.Key.ToString;
      // Resources[ResourceName] := ResMgr.GetObject(ResourceName);
     end else
     begin
      temp := '<none>';
      ResourceName := '';
     end;
    node := parent.Nodes.Add(System.string.Format('{0} ({1})', ResourceName, temp));
    node.Tag := entry.Value;
   end;
end;

procedure Form1.ShowSelectedNode;
var
  node: TreeNode;
begin
  node := Self.resourcesTreeView.SelectedNode;
  if node <> nil then
    begin // Display here?
    end;
end;

procedure Form1.fileOpenMenuItem_Click(sender: System.Object; e: System.EventArgs);
begin
  if openFileDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK then
    LoadResourcesFromFile(Self.openFileDialog1.FileName);
end;

procedure Form1.fileExitMenuItem_Click(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure Form1.helpAboutMenuItem_Click(sender: System.Object; e: System.EventArgs);
begin
  MessageBox.Show('Have fun!', 'About ResourceExplorer');
end;

procedure Form1.resourcesTreeView_DoubleClick(sender: System.Object; e: System.EventArgs);
begin
  ShowSelectedNode;
end;

procedure Form1.resourcesTreeView_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
begin
  if (e.KeyCode and Keys.Enter) = Keys.Enter then
    ShowSelectedNode;
end;

procedure Form1.resourcesTreeView_AfterSelect(sender: System.Object; e: System.Windows.Forms.TreeViewEventArgs);
var
  node: TreeNode;
begin
  statusBar1.Text := '';
  node := Self.resourcesTreeView.SelectedNode;
  if (node <> nil) and (node.Tag <> nil) then
   statusBar1.Text := node.Tag.ToString;
end;

procedure Form1.ClearResources;
begin
  Resources.Clear;
end;

end.
